using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carl Jensen</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>04/11/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component implementing data persistence logic for 
	///	patient transfusion requirements data. 
	///</summary>

	public class PatientTransfusionRequirement
	{
		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2650"> 
		///		<ExpectedInput>Valid patient GUID</ExpectedInput>
		///		<ExpectedOutput>DataTable containing the patient's transfusion requirements</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="9157"> 
		///		<ExpectedInput>Valid patient GUID</ExpectedInput>
		///		<ExpectedOutput>DataTable containing patient's transfusion requirements from conversion</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2651"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>Retrieves transfusion requirements for a given patient</summary>
		///<param name="patientGuid">Patient GUID</param>
		///><returns>DataTable containing patient transfusion requirements</returns>
		public static DataTable GetTransfusionRequirementsForPatient(Guid patientGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetPatientTransfusionRequirements.patientguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetPatientTransfusionRequirements.divisioncode, System.Data.SqlDbType.Char)
			};
			
			prms[0].Value = patientGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
			return Common.StoredProcedure.GetData(STOREDPROC.GetPatientTransfusionRequirements.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/17/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2181"> 
		///		<ExpectedInput>DateRange</ExpectedInput>
		///		<ExpectedOutput>DataTable containing transfusion requirements</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2182"> 
		///		<ExpectedInput>Invalid DateRange</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Get the list of transfusion requirements for an optional date range
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <returns></returns>
		public static DataTable GetTransfusionRequiremetsForAllPatient(DateTime startDate, DateTime endDate)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetTransfusionRequirementsReport.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetTransfusionRequirementsReport.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetTransfusionRequirementsReport.divisioncode, System.Data.SqlDbType.Char,5)
			};
			
			if(startDate == DateTime.MinValue)
			{
				prms[0].Value = DBNull.Value;
				prms[1].Value = DBNull.Value;
			}
			else
			{
				prms[0].Value = startDate;
				prms[1].Value = endDate;
			}
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
				
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetTransfusionRequirementsReport.StoredProcName, prms);
			return ds.Tables[0];

		}
	}
}
